/**
 * Copyright (C) 2003 Billy Biggs <vektor@dumbterm.net>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef JPEGINPUT_H_INCLUDED
#define JPEGINPUT_H_INCLUDED

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct jpeginput_s jpeginput_t;

jpeginput_t *jpeginput_new( const char *filename, int ycbcr );
void jpeginput_delete( jpeginput_t *jpeginput );
unsigned int jpeginput_get_width( jpeginput_t *jpeginput );
unsigned int jpeginput_get_height( jpeginput_t *jpeginput );
uint8_t *jpeginput_get_scanline( jpeginput_t *jpeginput, int num );

#ifdef __cplusplus
};
#endif
#endif /* JPEGINPUT_H_INCLUDED */
