
#include <stdio.h>
#include <sys/time.h>
#include <gtk/gtk.h>

static int timediff( struct timeval *large, struct timeval *small )
{
    return (   ( ( large->tv_sec * 1000 * 1000 ) + large->tv_usec )
             - ( ( small->tv_sec * 1000 * 1000 ) + small->tv_usec ) );
}

int main( int argc, char **argv )
{
    GtkWidget *window;
    GtkWidget *combobox;
    GList *list = 0;
    int i, n;
    struct timeval before, after;

    fprintf (stderr, "Using GtkComboBox...\n");

    gtk_init (&argc, &argv);
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    combobox = gtk_combo_box_entry_new_text ();

    n = 10000;

    gettimeofday (&before, 0);
    for (i = 0; i < n; i++) {
        gtk_combo_box_append_text (GTK_COMBO_BOX (combobox), "A");
    }
    gettimeofday (&after, 0);

    fprintf (stderr, "Adding %d entries took\t%8d usec\t(%5.2f seconds).\n",
             n, timediff (&after, &before),
             ((double) timediff (&after, &before)) / (1000.0 * 1000.0));

    gtk_container_add (GTK_CONTAINER (window), combobox);

    gettimeofday (&before, 0);
    gtk_widget_realize (combobox);
    gettimeofday (&after, 0);

    fprintf (stderr, "Realize widget took\t\t%8d usec\t(%5.2f seconds).\n",
             timediff (&after, &before),
             ((double) timediff (&after, &before)) / (1000.0 * 1000.0));

    return 0;
}

