
#include <stdio.h>
#include <gtk/gtk.h>

int main( int argc, char **argv )
{
    GtkWidget *window;
    GtkWidget *button;
    GtkWidget *vbox;
    GtkBorder *border;
    GtkBorder *outborder;

    gtk_init (&argc, &argv);
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    g_signal_connect (G_OBJECT (window), "destroy",
                      G_CALLBACK (gtk_main_quit), NULL);
    g_signal_connect (G_OBJECT (window), "delete_event",
                      G_CALLBACK (gtk_main_quit), NULL);

    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), vbox);

    button = gtk_button_new_with_label ("Button");
    gtk_container_add (GTK_CONTAINER (vbox), button);
    GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

    if (GTK_WIDGET_CAN_DEFAULT (button)) {
        fprintf (stderr, "Button can default\n");
        gtk_widget_style_get (button, "default_border", &border, NULL);
        if (border)
            fprintf (stderr, "Border: %d %d %d %d\n",
                     border->left,
                     border->right,
                     border->top,
                     border->bottom);
        g_free (border);
    } else {
        fprintf (stderr, "Button cannot default\n");
    }

    gtk_widget_show_all (window);
    gtk_main ();
    return 0;
}

